<?php
// pages/admission.php
session_start();
require_once '../config/db.php';
$conn = getDB();
$user_id = $_SESSION['user_id'];

$sql = "SELECT a.application_id, s.status, s.score 
        FROM applications a 
        LEFT JOIN admission_status s ON a.application_id = s.application_id 
        WHERE a.user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$status = $result->fetch_assoc();
$stmt->close();
$conn->close();
?>
<div class="content">
    <h2>Admission Status</h2>
    <?php if ($status): ?>
        <p><strong>Application ID:</strong> <?php echo $status['application_id']; ?></p>
        <p><strong>Status:</strong> <?php echo ucfirst($status['status']); ?></p>
        <?php if ($status['score']): ?>
            <p><strong>Score:</strong> <?php echo $status['score']; ?></p>
        <?php endif; ?>
        <?php if ($status['status'] === 'accepted'): ?>
            <a href="../api/generate_admission_letter.php?application_id=<?php echo $status['application_id']; ?>" 
               class="btn pay-button">Download Admission Letter</a>
        <?php endif; ?>
    <?php else: ?>
        <p>No application submitted yet.</p>
    <?php endif; ?>
</div>