<?php
// create_admin.php
require_once '../config/db.php';
$conn = getDB();

// Only allow this to run once (remove/disable after first use)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = 'admin';  // Change to your desired username
    $password = 'securePassword123';  // Change to a strong password
    
    // Hash the password
    $hashed_password = password_hash($password, PASSWORD_BCRYPT);
    
    // Insert into admins table
    $stmt = $conn->prepare("INSERT INTO admins (username, password) VALUES (?, ?)");
    $stmt->bind_param("ss", $username, $hashed_password);
    
    if ($stmt->execute()) {
        echo "Admin account created successfully. DELETE THIS FILE IMMEDIATELY.";
    } else {
        echo "Error creating admin account: " . $conn->error;
    }
    
    $stmt->close();
} else {
    echo '
    <form method="POST">
        <h2>Create Initial Admin Account</h2>
        <p>This will create an admin with username "admin" and password "securePassword123"</p>
        <button type="submit">Create Admin</button>
    </form>
    ';
}

$conn->close();
?>