<?php
session_start();
require_once '../config/db.php';
$conn = getDB();
$user_id = $_SESSION['user_id'];
$sql = "SELECT status, paystack_reference FROM payments WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$payment = $result->fetch_assoc();
$stmt->close();
$conn->close();
?>
<div class="content">
    <h2>Payment Status</h2>
    <?php if ($payment && $payment['status'] === 'successful'): ?>
        <div class="alert alert-success">
            Payment Successful! Reference: <?php echo $payment['paystack_reference']; ?>
        </div>
    <?php else: ?>
       <!-- Inside payment.php -->
<div class="alert alert-info">
    No successful payment found. 
    <a href="direct_paystack.php" class="btn pay-button mt-3">Pay Now (Direct Form)</a>
</div>
    <?php endif; ?>
</div>