<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

$conn = getDB();

// Get filter parameters
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';
$date_filter = isset($_GET['date']) ? $_GET['date'] : '';

// Base query
$sql = "SELECT p.*, a.full_name, a.section 
        FROM payments p
        JOIN applications a ON p.application_id = a.application_id";

// Add filters if specified
$where_clauses = [];
if ($status_filter) {
    $where_clauses[] = "p.status = '" . $conn->real_escape_string($status_filter) . "'";
}
if ($date_filter) {
    $where_clauses[] = "DATE(p.created_at) = '" . $conn->real_escape_string($date_filter) . "'";
}

if (!empty($where_clauses)) {
    $sql .= " WHERE " . implode(' AND ', $where_clauses);
}

$sql .= " ORDER BY p.created_at DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Management - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container d-flex">
        <!-- SIDEBAR PLACEHOLDER - COPY FROM YOUR EXISTING SIDEBAR -->
         <?php include'sidebar.php'; ?>
        <div class="main-content">
            <div class="container-fluid py-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Payment Management</h2>
                    <div class="d-flex">
                        <div class="dropdown me-2">
                            <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="statusFilter" data-bs-toggle="dropdown">
                                <i class="bi bi-funnel"></i> Status: <?= $status_filter ? ucfirst($status_filter) : 'All' ?>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="?">All Statuses</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="?status=pending">Pending</a></li>
                                <li><a class="dropdown-item" href="?status=successful">Successful</a></li>
                                <li><a class="dropdown-item" href="?status=failed">Failed</a></li>
                            </ul>
                        </div>
                        <div class="input-group" style="width: 200px;">
                            <input type="date" class="form-control" id="dateFilter" value="<?= $date_filter ?>">
                            <button class="btn btn-primary" onclick="applyDateFilter()">
                                <i class="bi bi-filter"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Payment ID</th>
                                        <th>Application ID</th>
                                        <th>Applicant</th>
                                        <th>Section</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th>Reference</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while ($row = $result->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= $row['id'] ?></td>
                                        <td><?= $row['application_id'] ?></td>
                                        <td><?= htmlspecialchars($row['full_name']) ?></td>
                                        <td><?= ucfirst($row['section']) ?></td>
                                        <td>₦<?= number_format($row['amount'], 2) ?></td>
                                        <td>
                                            <span class="badge bg-<?= 
                                                $row['status'] == 'successful' ? 'success' : 
                                                ($row['status'] == 'failed' ? 'danger' : 'warning') 
                                            ?>">
                                                <?= ucfirst($row['status']) ?>
                                            </span>
                                        </td>
                                        <td><?= date('M j, Y H:i', strtotime($row['created_at'])) ?></td>
                                        <td><?= $row['paystack_reference'] ?></td>
                                        <td>
                                            <?php if ($row['status'] == 'pending'): ?>
                                                <button class="btn btn-sm btn-success" onclick="verifyPayment('<?= $row['paystack_reference'] ?>')">
                                                    <i class="bi bi-check-circle"></i> Verify
                                                </button>
                                            <?php else: ?>
                                                <span class="text-muted">Verified</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function applyDateFilter() {
            const date = document.getElementById('dateFilter').value;
            window.location.href = `?date=${date}<?= $status_filter ? '&status='.$status_filter : '' ?>`;
        }
        
        function verifyPayment(reference) {
            if (confirm('Verify this payment with Paystack?')) {
                $.ajax({
                    url: '../api/verify_payment.php',
                    type: 'POST',
                    data: { reference: reference },
                    dataType: 'json',
                    success: function(response) {
                        alert(response.message);
                        if (response.success) {
                            location.reload();
                        }
                    }
                });
            }
        }
    </script>
</body>
</html>
<?php $conn->close(); ?>