<?php
session_start();
require_once '../config/db.php';
require_once('../assets/fpdf/fpdf.php'); // Adjust path if needed

if (!isset($_SESSION['user_id']) || !isset($_GET['application_id'])) {
    die('Unauthorized or missing application ID.');
}

$conn = getDB();
$user_id = $_SESSION['user_id'];
$application_id = $_GET['application_id'];

// --- UPDATED SQL QUERY ---
// Select all columns, including 'photograph'
$sql = "SELECT * FROM applications WHERE user_id = ? AND application_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("is", $user_id, $application_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    die('Application not found.');
}
$app = $result->fetch_assoc();
$stmt->close();
$conn->close();

// Custom PDF class with enhanced watermark and header
class PDFWithWatermark extends FPDF {
    private $watermarkImage;

    function __construct($watermarkImage = '') {
        parent::__construct();
        $this->watermarkImage = $watermarkImage;
    }

    function Header() {
        // School logo (left side)
        $logoPath = '../assets/images/logo.png'; // Adjust if needed
        if (file_exists($logoPath)) {
            $this->Image($logoPath, 10, 8, 25);
        }

        // Banner image (right side)
        $bannerPath = '../assets/images/banner.png'; // Adjust if needed
        if (file_exists($bannerPath)) {
            $this->Image($bannerPath, 160, 8, 40);
        }

        // School name and contact
        $this->SetFont('Arial', 'B', 14);
        $this->Cell(0, 8, 'UBEC MODEL SMART SCHOOL DAURA', 0, 1, 'C');
        $this->SetFont('Arial', '', 11);
        $this->Cell(0, 6, '2024/2025 Academic Session', 0, 1, 'C');
        $this->Cell(0, 6, 'Contact: +234 801 234 5678 | Email: info@ubecsmartschool.edu.ng', 0, 1, 'C');

        // Line separator
        $this->SetDrawColor(200, 200, 200);
        $this->SetLineWidth(0.5);
        $this->Line(10, 35, 200, 35);
        $this->Ln(10);
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

    function AddPage($orientation='', $size='', $rotation=0) {
        parent::AddPage($orientation, $size, $rotation);
        // Watermark image with simulated opacity by using a faded PNG
        if ($this->watermarkImage && file_exists($this->watermarkImage)) {
            // FPDF does not support native opacity; use a faded PNG for watermark
            $imageWidth = 150;
            $imageHeight = 150 * 0.75; // Assuming aspect ratio
            $x = ($this->GetPageWidth() - $imageWidth) / 2;
            $y = ($this->GetPageHeight() - $imageHeight) / 2;
            $this->Image($this->watermarkImage, $x, $y, $imageWidth, $imageHeight);
        } else {
            // Fallback: text watermark
            $this->SetFont('Arial','B',50);
            $this->SetTextColor(230,230,230);
            $this->Rotate(45, 60, 190);
            $this->Text(35, 190, 'UBEC SMART SCHOOL');
            $this->Rotate(0);
            $this->SetTextColor(0,0,0);
        }
    }

    // Simple rotate function for watermark
    function Rotate($angle, $x = -1, $y = -1) {
        if($x == -1)
            $x = $this->x;
        if($y == -1)
            $y = $this->y;
        if($this->angle != 0)
            $this->_out('Q');
        $this->angle = $angle;
        if($angle != 0) {
            $angle *= M_PI/180;
            $c = cos($angle);
            $s = sin($angle);
            $cx = $x*$this->k;
            $cy = ($this->h-$y)*$this->k;
            $this->_out(sprintf('q %.5F %.5F %.5F %.5F %.2F %.2F cm', $c, $s, -$s, $c, $cx, $cy));
        }
    }
    var $angle = 0;

    function _endpage() {
        if($this->angle != 0) {
            $this->angle = 0;
            $this->_out('Q');
        }
        parent::_endpage();
    }
}

// Path to your watermark image (should be a PNG with transparency)
$watermarkImagePath = '../assets/images/watermark.png'; // Use a faded PNG for best effect

// Create PDF with watermark image
$pdf = new PDFWithWatermark($watermarkImagePath);
$pdf->AliasNbPages();
$pdf->AddPage();

// Title
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 12, 'Application Acknowledgement Slip', 0, 1, 'C');
$pdf->Ln(3);

// --- ADD PHOTOGRAPH HERE ---
$photographPath = '';
if (isset($app['photograph']) && !empty($app['photograph'])) {
    $photographPath = '../uploads/' . $app['photograph'];
    if (file_exists($photographPath)) {
        // Position the photograph in the top right, with a small border
        $photoWidth = 40; // Adjust size as needed
        $photoHeight = 40; // Adjust size as needed (maintain aspect ratio)
        $xPos = $pdf->GetPageWidth() - $photoWidth - 15; // 15mm from right edge
        // Adjust photo Y position to be slightly lower than the header
        $yPos = 40; // Adjusted from 45 to 40 for better spacing

        $pdf->Rect($xPos - 0.5, $yPos - 0.5, $photoWidth + 1, $photoHeight + 1, 'D'); // Add a subtle border
        $pdf->Image($photographPath, $xPos, $yPos, $photoWidth, $photoHeight);
    } else {
        error_log("Acknowledgement Slip: Photograph file not found at " . $photographPath);
    }
} else {
    error_log("Acknowledgement Slip: Photograph filename not found in DB for application ID " . $application_id);
}

// Adjust starting Y position for application details to avoid overlapping with photo and title
// This Y position should be below the title and the photograph
$pdf->SetY(60); // Adjusted from 45 to 85 to provide more space

// Application details in a more organized layout
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(60, 8, 'Application ID:', 0, 0);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 8, $app['application_id'], 0, 1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(60, 8, 'Section:', 0, 0);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 8, $app['section'], 0, 1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(60, 8, 'Full Name:', 0, 0);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 8, isset($app['full_name']) ? $app['full_name'] : '', 0, 1); // Ensure 'full_name' is used

// Continue with other fields in the same pattern...
$fields = [
    'Gender' => 'gender',
    'Date of Birth' => 'dob',
    'Age' => 'age', // Added age
    'LGA' => 'lga',
    'State' => 'state',
    'Parent/Guardian' => 'parent_name',
    'Parent Occupation' => 'parent_occupation', // Added
    'Parent Phone' => 'parent_phone',
    'Parent Email' => 'parent_email',
    'Current School' => 'current_school', // Added, will be empty for primary
    'Current Class' => 'current_class',   // Added, will be empty for primary
    'Health Status' => 'health_status',
    'Disability' => 'disability',
    'Other Disability' => 'other_disability', // Added
    'Date Submitted' => 'application_date' // Changed to application_date for consistency
];

foreach ($fields as $label => $field) {
    // Skip empty fields for better presentation, especially for optional ones like current_school
    if (empty($app[$field]) && $app[$field] !== 0 && $field !== 'other_disability') { // Don't skip if other_disability is null/empty but disability is 'OTHER'
        continue;
    }
    if ($field === 'other_disability' && ($app['disability'] !== 'OTHER' || empty($app[$field]))) {
        continue; // Only show other_disability if disability is 'OTHER' and it's not empty
    }

    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(60, 8, $label . ':', 0, 0);
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell(0, 8, isset($app[$field]) ? $app[$field] : '', 0, 1);
}

$pdf->Ln(10);
$pdf->SetFont('Arial', 'I', 11);
$pdf->Cell(0, 8, 'Thank you for your application.', 0, 1, 'C');

// Add some official note
$pdf->SetFont('Arial', '', 10);
$pdf->MultiCell(0, 6, "Note: This acknowledgement slip serves as proof of application submission. Please present this document when required for verification purposes. For any inquiries, please contact the school administration.", 0, 'C');

// Output PDF for download
$pdf->Output('D', 'acknowledgement_' . $application_id . '.pdf');
exit;
?>
