<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['admin_id'])) {
    die('Unauthorized access');
}

$conn = getDB();
$section = isset($_GET['section']) ? $_GET['section'] : '';

// Validate section
if (!in_array($section, ['primary', 'junior'])) {
    die('Invalid section specified');
}

// Query admitted applicants for the specified section
$sql = "SELECT a.application_id, a.full_name, a.state, a.lga
        FROM applications a
        JOIN admission_status s ON a.application_id = s.application_id
        WHERE a.section = ? AND s.status = 'accepted'
        ORDER BY a.full_name";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $section);
$stmt->execute();
$result = $stmt->get_result();

// Set the filename
$filename = 'Admitted_' . ucfirst($section) . '_Applicants_' . date('Y-m-d') . '.csv';

// Output headers
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="' . $filename . '"');

// Open output stream
$output = fopen('php://output', 'w');

// Write CSV headers
fputcsv($output, ['S/N', 'Application ID', 'Full Name', 'State', 'LGA']);

// Write data
$sn = 1;
while ($applicant = $result->fetch_assoc()) {
    fputcsv($output, [
        $sn++,
        $applicant['application_id'],
        $applicant['full_name'],
        $applicant['state'],
        $applicant['lga']
    ]);
}

fclose($output);
exit;
?>