<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

try {
    require_once '../config/db.php';
    $conn = getDB();

    // Validate inputs
    $first_name = isset($_POST['first_name']) ? trim($_POST['first_name']) : '';
    $last_name = isset($_POST['last_name']) ? trim($_POST['last_name']) : '';
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $password = isset($_POST['password']) ? password_hash(trim($_POST['password']), PASSWORD_BCRYPT) : '';

    if (empty($first_name) || empty($last_name) || empty($email) || empty($_POST['password'])) {
        echo json_encode(['success' => false, 'message' => 'All fields are required']);
        exit;
    }

    // Check if email exists
    $sql = "SELECT id FROM users WHERE email = ?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param("s", $email);
    $stmt->execute();
    if ($stmt->get_result()->num_rows > 0) {
        echo json_encode(['success' => false, 'message' => 'Email already exists']);
        exit;
    }

    // Insert user
    $sql = "INSERT INTO users (first_name, last_name, email, password) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param("ssss", $first_name, $last_name, $email, $password);
    if ($stmt->execute()) {
        // Optionally load WordPress
        if (file_exists('../wordpress/wp-load.php')) {
            require_once '../wordpress/wp-load.php';
            $wp_user_id = wp_create_user($email, $_POST['password'], $email);
            if (is_wp_error($wp_user_id)) {
                echo json_encode(['success' => false, 'message' => 'Failed to create WordPress user: ' . $wp_user_id->get_error_message()]);
            } else {
                echo json_encode(['success' => true]);
            }
        } else {
            echo json_encode(['success' => true, 'message' => 'WordPress not found, user registered in portal only']);
        }
    } else {
        throw new Exception("Insert failed: " . $conn->error);
    }

    $stmt->close();
    $conn->close();
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
?>