<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

$conn = getDB();

// Get statistics
$stats = [
    'total_applicants' => 0,
    'primary_applicants' => 0,
    'junior_applicants' => 0,
    'pending_applications' => 0,
    'accepted_applications' => 0,
    'rejected_applications' => 0,
    'total_payments' => 0,
    'successful_payments' => 0,
    'recent_applications' => []
];

// Total applicants
$query = "SELECT COUNT(*) as count FROM applications";
$result = $conn->query($query);
$stats['total_applicants'] = $result->fetch_assoc()['count'];

// By section
$query = "SELECT section, COUNT(*) as count FROM applications GROUP BY section";
$result = $conn->query($query);
while ($row = $result->fetch_assoc()) {
    if ($row['section'] == 'primary') {
        $stats['primary_applicants'] = $row['count'];
    } else {
        $stats['junior_applicants'] = $row['count'];
    }
}

// Application statuses
$query = "SELECT status, COUNT(*) as count FROM admission_status GROUP BY status";
$result = $conn->query($query);
while ($row = $result->fetch_assoc()) {
    if ($row['status'] == 'pending') {
        $stats['pending_applications'] = $row['count'];
    } elseif ($row['status'] == 'accepted') {
        $stats['accepted_applications'] = $row['count'];
    } elseif ($row['status'] == 'rejected') {
        $stats['rejected_applications'] = $row['count'];
    }
}

// Payment stats
$query = "SELECT COUNT(*) as count FROM payments";
$result = $conn->query($query);
$stats['total_payments'] = $result->fetch_assoc()['count'];

$query = "SELECT COUNT(*) as count FROM payments WHERE status = 'successful'";
$result = $conn->query($query);
$stats['successful_payments'] = $result->fetch_assoc()['count'];

// Recent applications
$query = "SELECT a.application_id, a.full_name, a.section, a.submitted_at, s.status 
          FROM applications a
          LEFT JOIN admission_status s ON a.application_id = s.application_id
          ORDER BY a.submitted_at DESC LIMIT 5";
$result = $conn->query($query);
while ($row = $result->fetch_assoc()) {
    $stats['recent_applications'][] = $row;
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <style>
        .stat-card {
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
            border-left: 5px solid;
            height: 100%;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .stat-card.primary {
            border-left-color: #4e73df;
        }
        .stat-card.junior {
            border-left-color: #1cc88a;
        }
        .stat-card.pending {
            border-left-color: #f6c23e;
        }
        .stat-card.accepted {
            border-left-color: #36b9cc;
        }
        .stat-card.rejected {
            border-left-color: #e74a3b;
        }
        .stat-card.payments {
            border-left-color: #5a5c69;
        }
        .stat-icon {
            font-size: 2rem;
            opacity: 0.3;
        }
        .chart-container {
            height: 300px;
        }
        .sidebar {
            width: 250px;
            min-height: 100vh;
            transition: all 0.3s;
        }
        .sidebar-header {
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.25rem;
            margin: 0.25rem 0.5rem;
            transition: all 0.2s;
        }
        .nav-link:hover, .nav-link.active {
            color: white;
            background-color: rgba(255, 255, 255, 0.1);
        }
        .nav-link i {
            margin-right: 0.5rem;
        }
        .main-content {
            flex: 1;
            background-color: #f8f9fa;
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="admin-container d-flex">
        <!-- Sidebar (matches applicants.php style) -->
     <?php include'sidebar.php'; ?>

        <!-- Main Content -->
        <div class="main-content">
            <div class="container-fluid py-4">
                <h2 class="mb-4">System Overview</h2>
                
                <!-- Stats Cards Row -->
                <div class="row mb-4 g-4">
                    <!-- Total Applicants -->
                    <div class="col-xl-3 col-md-6">
                        <div class="card stat-card h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total Applicants</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= number_format($stats['total_applicants']) ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-people stat-icon text-primary"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Primary Applicants -->
                    <div class="col-xl-3 col-md-6">
                        <div class="card stat-card primary h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Primary Applicants</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= number_format($stats['primary_applicants']) ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-person stat-icon text-primary"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Junior Applicants -->
                    <div class="col-xl-3 col-md-6">
                        <div class="card stat-card junior h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Junior Applicants</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= number_format($stats['junior_applicants']) ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-person-plus stat-icon text-success"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Successful Payments -->
                    <div class="col-xl-3 col-md-6">
                        <div class="card stat-card payments h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-dark text-uppercase mb-1">
                                            Successful Payments</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= number_format($stats['successful_payments']) ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-credit-card stat-icon text-dark"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Second Row of Stats -->
                <div class="row mb-4 g-4">
                    <!-- Pending Applications -->
                    <div class="col-xl-4 col-md-6">
                        <div class="card stat-card pending h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Pending Applications</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= number_format($stats['pending_applications']) ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-hourglass stat-icon text-warning"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Accepted Applications -->
                    <div class="col-xl-4 col-md-6">
                        <div class="card stat-card accepted h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            Accepted Applications</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= number_format($stats['accepted_applications']) ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-check-circle stat-icon text-info"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Rejected Applications -->
                    <div class="col-xl-4 col-md-6">
                        <div class="card stat-card rejected h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            Rejected Applications</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= number_format($stats['rejected_applications']) ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-x-circle stat-icon text-danger"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card shadow mb-4">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 font-weight-bold text-primary">Recent Applications</h6>
                                <a href="applicants.php" class="btn btn-sm btn-primary">View All</a>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Application ID</th>
                                                <th>Name</th>
                                                <th>Section</th>
                                                <th>Date</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($stats['recent_applications'] as $row): ?>
                                            <tr>
                                                <td><?= $row['application_id'] ?></td>
                                                <td><?= htmlspecialchars($row['full_name']) ?></td>
                                                <td><?= ucfirst($row['section']) ?></td>
                                                <td><?= date('M j, Y', strtotime($row['submitted_at'])) ?></td>
                                                <td>
                                                    <span class="badge bg-<?= 
                                                        $row['status'] == 'accepted' ? 'success' : 
                                                        ($row['status'] == 'rejected' ? 'danger' : 'warning') 
                                                    ?>">
                                                        <?= ucfirst($row['status'] ?: 'pending') ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="applicants.php?view=<?= $row['application_id'] ?>" 
                                                       class="btn btn-sm btn-outline-primary">
                                                        <i class="bi bi-eye"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        // Application Status Chart
        const statusCtx = document.getElementById('statusChart').getContext('2d');
        const statusChart = new Chart(statusCtx, {
            type: 'doughnut',
            data: {
                labels: ['Pending', 'Accepted', 'Rejected'],
                datasets: [{
                    data: [
                        <?= $stats['pending_applications'] ?>,
                        <?= $stats['accepted_applications'] ?>,
                        <?= $stats['rejected_applications'] ?>
                    ],
                    backgroundColor: [
                        '#f6c23e',
                        '#1cc88a',
                        '#e74a3b'
                    ],
                    hoverBackgroundColor: [
                        '#f8d369',
                        '#2fe5a0',
                        '#f06960'
                    ],
                    hoverBorderColor: "rgba(234, 236, 244, 1)",
                }],
            },
            options: {
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                cutout: '70%',
            },
        });

        // Section Distribution Chart
        const sectionCtx = document.getElementById('sectionChart').getContext('2d');
        const sectionChart = new Chart(sectionCtx, {
            type: 'pie',
            data: {
                labels: ['Primary', 'Junior'],
                datasets: [{
                    data: [
                        <?= $stats['primary_applicants'] ?>,
                        <?= $stats['junior_applicants'] ?>
                    ],
                    backgroundColor: [
                        '#4e73df',
                        '#1cc88a'
                    ],
                    hoverBackgroundColor: [
                        '#6a8aec',
                        '#2fe5a0'
                    ],
                    hoverBorderColor: "rgba(234, 236, 244, 1)",
                }],
            },
            options: {
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
            },
        });
    </script>
</body>
</html>