<?php
session_start();
require_once '../config/db.php';
$conn = getDB();
$user_id = $_SESSION['user_id'];

// Initialize application_id and application_data
$application_id = null;
$application_data = null;
$already_applied = false;

// Priority 1: Check for application_id from a recent payment in session
if (isset($_SESSION['current_application_id'])) {
    $temp_application_id = $_SESSION['current_application_id'];

    // Check if this specific application_id from session has already been applied
    $app_check = $conn->prepare("SELECT * FROM applications WHERE application_id = ? AND user_id = ?");
    $app_check->bind_param("si", $temp_application_id, $user_id);
    $app_check->execute();
    $app_result = $app_check->get_result();

    if ($app_result->num_rows > 0) {
        $already_applied = true;
        $application_data = $app_result->fetch_assoc();
        $application_id = $temp_application_id; // Use this ID for display
    } else {
        // If not yet applied, use this ID for the new form
        $application_id = $temp_application_id;
    }
    $app_check->close();
}

// Priority 2: If no application_id from session, find an uncompleted successful payment
if (!$application_id) {
    $payment_check = $conn->prepare("
        SELECT application_id FROM payments 
        WHERE user_id = ? AND status = 'successful' AND application_completed = 0
        ORDER BY created_at DESC LIMIT 1
    ");
    $payment_check->bind_param("i", $user_id);
    $payment_check->execute();
    $payment_result = $payment_check->get_result();

    if ($payment_result->num_rows > 0) {
        $payment_data = $payment_result->fetch_assoc();
        $application_id = $payment_data['application_id'];
        // Set this ID in session for consistency
        $_SESSION['current_application_id'] = $application_id;
    }
    $payment_check->close();
}

// Priority 3: If still no application_id, check for ANY existing application for the user
// This handles cases where application_completed might not have been set for old records
if (!$application_id && !$already_applied) {
    $existing_app_for_user = $conn->prepare("SELECT * FROM applications WHERE user_id = ? ORDER BY submitted_at DESC LIMIT 1");
    $existing_app_for_user->bind_param("i", $user_id);
    $existing_app_for_user->execute();
    $existing_app_result = $existing_app_for_user->get_result();
    if ($existing_app_result->num_rows > 0) {
        $already_applied = true;
        $application_data = $existing_app_result->fetch_assoc();
        $application_id = $application_data['application_id']; // Use this ID for display
    }
    $existing_app_for_user->close();
}


// If no valid application_id (either for new form or existing app) and no payment found, redirect
if (!$application_id && !$already_applied) {
    header("Location: payment.php");
    exit;
}

$conn->close();
?>
<!-- START OF CONTENT TO BE INJECTED INTO #content -->
<div class="content p-0" style="background:none;box-shadow:none;border-radius:0;">
    <?php if ($already_applied): ?>
        <div class="alert alert-info">
            <h4>Application Submitted</h4>
            <p>Your application has already been submitted successfully.</p>
        </div>
        
        <?php if ($application_data): ?>
            <div class="card mt-4">
                <div class="card-header bg-primary text-white">
                    <strong>Application Details</strong>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Application ID:</strong> <?php echo htmlspecialchars($application_data['application_id']); ?></p>
                            <p><strong>Section:</strong> <?php echo htmlspecialchars(ucfirst($application_data['section'])); ?></p>
                            <p><strong>Full Name:</strong> <?php echo htmlspecialchars($application_data['full_name']); ?></p>
                            <p><strong>Date of Birth:</strong> <?php echo htmlspecialchars($application_data['dob']); ?></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Age:</strong> <?php echo htmlspecialchars($application_data['age']); ?></p>
                            <p><strong>LGA:</strong> <?php echo htmlspecialchars($application_data['lga']); ?></p>
                            <p><strong>State:</strong> <?php echo htmlspecialchars($application_data['state']); ?></p>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <a href="../api/acknowledgement_slip.php?application_id=<?php echo urlencode($application_data['application_id']); ?>" 
                           class="btn btn-primary me-2" target="_blank">
                            <i class="bi bi-download"></i> Download Acknowledgement Slip
                        </a>
                        <a href="admission.php" class="btn btn-success">
                            <i class="bi bi-eye"></i> View Admission Status
                        </a>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        
    <?php else: ?>
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">New Application</h4>
                <p class="mb-0">Application ID: <?php echo $application_id; ?></p>
            </div>
            
            <div class="card-body">
                <form id="admissionForm" enctype="multipart/form-data">
                    <input type="hidden" name="application_id" value="<?php echo htmlspecialchars($application_id); ?>">
                    
                    <!-- SECTION: Applicant Type -->
                    <div class="mb-4 border-bottom pb-3">
                        <h5 class="mb-3">1. Applicant Type</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="applicantType" id="primaryApplicant" value="primary" checked>
                                    <label class="form-check-label" for="primaryApplicant">
                                        <strong>Primary Section</strong> (Age 5+)
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="applicantType" id="juniorApplicant" value="junior">
                                    <label class="form-check-label" for="juniorApplicant">
                                        <strong>Junior Section</strong> (Age 12+)
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- SECTION: Bio Data -->
                    <div class="mb-4 border-bottom pb-3">
                        <h5 class="mb-3">2. Bio Data</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="fullName" class="form-label">Full Name (Surname First)</label>
                        <input type="text" class="form-control" id="fullName" name="fullName" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label d-block">Gender</label>
                        <div>
                            <input type="radio" name="gender" value="MALE" id="male" required>
                            <label for="male" class="me-3">Male</label>
                            <input type="radio" name="gender" value="FEMALE" id="female">
                            <label for="female">Female</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label for="dob" class="form-label">Date of Birth</label>
                        <input type="date" class="form-control" id="dob" name="dob" required>
                    </div>
                    <div class="col-md-6">
                        <label for="lga" class="form-label">Local Government Area</label>
                        <input type="text" class="form-control" id="lga" name="lga" required>
                    </div>
                    <div class="col-md-6">
                        <label for="state" class="form-label">State of Origin</label>
                        <select class="form-select" id="state" name="state" required>
                            <option value="" selected disabled>Select State</option>
                            <option value="ABIA">ABIA</option>
                            <option value="ADAMAWA">ADAMAWA</option>
                            <option value="KATSINA">KATSINA</option>
                            <!-- ...other states... -->
                        </select>
                    </div>
                </div>
            </div>
            <!-- SECTION: Parent/Guardian Info -->
            <div class="mb-4">
                <h5 class="mb-3">Parent/Guardian Information</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="parentName" class="form-label">Full Name</label>
                        <input type="text" class="form-control" id="parentName" name="parentName" required>
                    </div>
                    <div class="col-md-6">
                        <label for="parentOccupation" class="form-label">Occupation</label>
                        <input type="text" class="form-control" id="parentOccupation" name="parentOccupation" required>
                    </div>
                    <div class="col-md-6">
                        <label for="parentPhone" class="form-label">Phone Number</label>
                        <input type="tel" class="form-control" id="parentPhone" name="parentPhone" required>
                    </div>
                    <div class="col-md-6">
                        <label for="parentEmail" class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="parentEmail" name="parentEmail" required>
                    </div>
                </div>
            </div>
            <!-- SECTION: Academic Background (Junior Only) -->
            <div id="juniorAcademicSection" class="mb-4" style="display:none;">
                <h5 class="mb-3">Academic Background (Junior Only)</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="currentSchool" class="form-label">Present School</label>
                        <input type="text" class="form-control" id="currentSchool" name="currentSchool">
                    </div>
                    <div class="col-md-6">
                        <label for="currentClass" class="form-label">Current Class</label>
                        <select class="form-select" id="currentClass" name="currentClass">
                            <option value="" selected disabled>Select Class</option>
                            <option value="PRIMARY 1">PRIMARY 1</option>
                            <option value="PRIMARY 2">PRIMARY 2</option>
                            <option value="PRIMARY 3">PRIMARY 3</option>
                            <option value="PRIMARY 4">PRIMARY 4</option>
                            <option value="PRIMARY 5">PRIMARY 5</option>
                            <option value="PRIMARY 6">PRIMARY 6</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="applicationDate" class="form-label">Date of Application</label>
                        <input type="date" class="form-control" id="applicationDate" name="applicationDate" value="<?php echo date('Y-m-d'); ?>">
                    </div>
                </div>
            </div>
            <!-- SECTION: Medical History -->
            <div class="mb-4">
                <h5 class="mb-3">Medical History</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="healthStatus" class="form-label">Health Status</label>
                        <select class="form-select" id="healthStatus" name="healthStatus" required>
                            <option value="" selected disabled>Select Health Status</option>
                            <option value="EXCELLENT">EXCELLENT</option>
                            <option value="GOOD">GOOD</option>
                            <option value="FAIR">FAIR</option>
                            <option value="POOR">POOR</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label d-block">Disability (if any)</label>
                        <div>
                            <input type="radio" name="disability" value="NONE" id="none" checked>
                            <label for="none" class="me-2">None</label>
                            <input type="radio" name="disability" value="PHYSICAL DISABILITY" id="physical">
                            <label for="physical" class="me-2">Physical Disability</label>
                            <input type="radio" name="disability" value="HEARING IMPAIRMENT" id="hearing">
                            <label for="hearing" class="me-2">Hearing Impairment</label>
                            <input type="radio" name="disability" value="VISUAL IMPAIRMENT" id="visual">
                            <label for="visual" class="me-2">Visual Impairment</label>
                            <input type="radio" name="disability" value="OTHER" id="other">
                            <label for="other">Other (Specify)</label>
                        </div>
                        <input type="text" class="form-control mt-2 d-none" id="otherDisability" name="otherDisability" placeholder="Specify Disability">
                    </div>
                </div>
            </div>
            <!-- SECTION: Admission Requirements (File Uploads) -->
            <div class="mb-4">
                <h5 class="mb-3">Admission Requirements</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="photograph" class="form-label">Passport Photograph</label>
                        <input type="file" class="form-control" id="photograph" name="photograph" accept=".jpg,.jpeg,.png" required>
                    </div>
                    <div class="col-md-6">
                        <label for="birthCert" class="form-label">Birth Certificate/Declaration of Age</label>
                        <input type="file" class="form-control" id="birthCert" name="birthCert" accept=".pdf,.jpg,.jpeg,.png" required>
                    </div>
                    <div class="col-md-6">
                        <label for="lgaCert" class="form-label">Local Government Indigen Certificate</label>
                        <input type="file" class="form-control" id="lgaCert" name="lgaCert" accept=".pdf,.jpg,.jpeg,.png" required>
                    </div>
                    <div class="col-md-6">
                        <label for="medicalReport" class="form-label">Certified Medical Report</label>
                        <input type="file" class="form-control" id="medicalReport" name="medicalReport" accept=".pdf,.jpg,.jpeg,.png" required>
                    </div>
                    <div class="col-md-6">
                        <label for="immunizationCard" class="form-label">Immunization/Vaccination Card</label>
                        <input type="file" class="form-control" id="immunizationCard" name="immunizationCard" accept=".pdf,.jpg,.jpeg,.png" required>
                    </div>
                    <div class="col-md-6" id="primaryCertDiv" style="display:none;">
                        <label for="primaryCert" class="form-label">Primary School Leaving Certificate (Junior Only)</label>
                        <input type="file" class="form-control" id="primaryCert" name="primaryCert" accept=".pdf,.jpg,.jpeg,.png">
                    </div>
                </div>
            </div>
            <!-- SECTION: Declaration -->
            <div class="mb-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="declaration" name="declaration" value="1" required>
                    <label class="form-check-label" for="declaration">
                        I declare that all information provided is true and correct.
                    </label>
                </div>
            </div>
             <div class="mt-4">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="bi bi-send"></i> Submit Application
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <script>
            $(document).ready(function() {
                // Show/hide sections based on applicant type
                $('input[name="applicantType"]').change(function() {
                    if ($(this).val() === 'junior') {
                        $('#juniorAcademicSection').show();
                        $('#primaryCertDiv').show();
                        $('#primaryCert').prop('required', true);
                    } else {
                        $('#juniorAcademicSection').hide();
                        $('#primaryCertDiv').hide();
                        $('#primaryCert').prop('required', false);
                    }
                }).trigger('change');

                // Handle disability field
                $('input[name="disability"]').change(function() {
                    if ($(this).val() === 'OTHER') {
                        $('#otherDisability').removeClass('d-none').prop('required', true);
                    } else {
                        $('#otherDisability').addClass('d-none').prop('required', false);
                    }
                });

                // Form submission
 $('#admissionForm').submit(function(e) {
    e.preventDefault();
    var formData = new FormData(this);
    
    $.ajax({
        url: '../api/application.php',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            if (response.success) {
                // Success - refresh to show submitted application
                window.location.reload();
            } else {
                // Only show error if not a "duplicate" message
                if (!response.message.includes('already submitted')) {
                    alert(response.message);
                }
                // For duplicates, just refresh (shouldn't happen in normal flow)
                window.location.reload();
            }
        }
    });
});     });
        </script>
    <?php endif; ?>
</div>
