<?php
// primary_admitted.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once '../config/db.php';
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

$conn = getDB();
$sql = "SELECT a.application_id, a.full_name, a.state, a.lga
        FROM applications a
        JOIN admission_status s ON a.application_id = s.application_id
        WHERE a.section = 'primary' AND s.status = 'accepted'
        ORDER BY a.full_name";
$result = $conn->query($sql);
?>

<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Admitted Primary Applicants</h2>
        <a href="../api/export_admitted.php?section=primary" class="btn btn-success">
            <i class="bi bi-download"></i> Export to Excel
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Application ID</th>
                        <th>Full Name</th>
                        <th>State</th>
                        <th>LGA</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $row['application_id']; ?></td>
                        <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                        <td><?php echo $row['state']; ?></td>
                        <td><?php echo $row['lga']; ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>