<?php
session_start();
header('Content-Type: application/json');
require_once '../config/db.php';
require_once '../vendor/autoload.php';

use Yabacon\Paystack;

$paystack = new Paystack('sk_test_e481317915421729ecc683a9231a26dd1d1d19c9'); // <-- Replace with your valid Paystack secret key

// Get reference from POST or GET (Paystack may send it differently)
$reference = $_POST['reference'] ?? $_GET['reference'] ?? null;

if (!$reference) {
    // Log the error for debugging
    error_log("Paystack verification failed: No reference provided. Received data: " . print_r($_REQUEST, true));
    echo json_encode(['success' => false, 'message' => 'No reference provided']);
    exit;
}

try {
    // Verify transaction with Paystack
    $transaction = $paystack->transaction->verify(['reference' => $reference]);
    
    if ($transaction->data->status === 'success') {
        $conn = getDB();
        $user_id = $_SESSION['user_id'];
        $amount = $transaction->data->amount / 100; // Convert to Naira
        
        // Generate application_id
        $application_id = 'APP' . time() . rand(1000, 9999);
        
        // Save payment with application_id
        $sql = "INSERT INTO payments (
                user_id, 
                application_id, 
                paystack_reference, 
                amount, 
                status
               ) VALUES (?, ?, ?, ?, 'successful')";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("issd", $user_id, $application_id, $reference, $amount);
        
        if ($stmt->execute()) {
            // Store application_id in session for the application form
            $_SESSION['current_application_id'] = $application_id;

            echo json_encode([
                'success' => true,
                'application_id' => $application_id,
                'redirect' => 'application.php',
                'redirect_url' => '../pages/application.php' // add redirect_url for frontend use
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Database error']);
        }
        
        $stmt->close();
        $conn->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Payment not successful']);
    }
} catch (Exception $e) {
    error_log("Paystack verification error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>